//------------------------------------------------------------------------------
// File: cmn_arrayargs.cs
// This file contains functionality for working with arrays in the game.
// Author: Michael Felice
// Copyright: Sandlot Games, 2007
//------------------------------------------------------------------------------



function ArrayStart()
{
   $ARRAY_ARGV[0] = 0;
   $ARRAY_ARGC = 0;
}

function ArrayToArg(%pos, %value)
{
   %dim = getWordCount(%pos);
   if (%dim == 0)
   {
      error("Attempting to set a value in an array to use as a function argument, but no position is given to set value.");
      return;
   }
   if (%dim > 1)
   {
      error("Cannot set position of array argument, too many positions were used.");
      return;
   }
   
   $ARRAY_ARGV[getWord(%pos, 0)] = %value;
   if (getWord(%pos, 0) >= $ARRAY_ARGC) $ARRAY_ARGC = getWord(%pos, 0) + 1;
}

function ArrayToDim()
{
   return $ARRAY_ARGC;
}

function ArrayToDim(%dim)
{
   if (%dim < 0 || %dim > 2)
   {
      return 0;
   }
   
   return $ARRAY_ARGC[%dim];
}

function ArrayToValue(%pos)
{
   %dim = getWordCount(%pos);
   if (%dim == 0)
   {
      error("Attempting to access a value in an array to use as a function argument, but no position is given to set value.");
      return;
   }
   if (%dim > 1)
   {
      error("Cannot access position of array argument, too many positions were used.");
      return;
   }
   
   return $ARRAY_ARGV[getWord(%pos, 0)];
}

